cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccd
c
c  this is the driver of the adaptive fast multipole code.
c
c  the following variables should be defined in the driver.
c
c    natoms: total number of atoms.
c    beta: the frequency of the equation.
c    zat(3,natoms): particle locations.
c    charge(natoms) : charge each particle carries.
c    pot(natoms): potential at each particle location.
c    field(3,natoms): field at each particle location.
c    ier: error message.
c
c  a subroutine is provided to compare fmm results with direct results,
c  so you also provide the following vectors for such comparisons.
c
c    dpot(natoms): potential using direct summation.
c    dfield(3,natoms): field using direct summation.
c
c  for advanced users:
c    if you want to change the precision of this code, you can check
c    parm-ayuk.h.
c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccd
c
      IMPLICIT NONE
c
      INTEGER *4 NATOMS,IER
      PARAMETER (NATOMS=100000)
      REAL *8 BETA,ZAT(3,NATOMS),CHARGE(NATOMS)
      REAL *8 POT(NATOMS),DPOT(NATOMS)
      REAL *8 FIELD(3,NATOMS),DFIELD(3,NATOMS)
c
c-----external functions.
c
      REAL *8 SECOND
c
c-----more local variables.
c
      INTEGER *4 I,IMAX
      REAL *8 CTOT,TIME0,TIME1,SALG,STOT,SALG2,STOT2
      REAL *8 TT,EALG,ERRMAX
c
c-----call initialization routines
c     0. initialize the output units.
c        6: screen.
c        13: fort.13.
c
      CALL PRINI(6,13)
c
c-----1. set up parameters.
c
      BETA=0.1D0
      CALL PRIN2('beta = *',BETA,1)
      CALL PRINF('natoms = *',NATOMS,1)
c
c-----2. generate charges and their locations.
c
      CALL DUMMY(NATOMS,ZAT,CHARGE)
c
c-----3. main fmm call, call fmm to calculate the potential
c
      TIME0 = SECOND()
      CALL FMMYUK_A(BETA,NATOMS,ZAT,CHARGE,POT,FIELD,IER)
      TIME1=SECOND()
c
      CALL PRIN2(' time for fmm work  is *',TIME1-TIME0,1)
      WRITE(11,554)TIME1-TIME0
554   FORMAT(' time for fmm work is ',F8.2)
c
c-----end of the fast multipole algorithm.
c
c-----4. finally, comparison with direct method.

      STOP
      END
