#!/bin/bash
# Run this script for benchmark preparation
# Datadump creation


# step one

					#debug
#echo $bench_dir 2>&1 |tee -a bench_dir
#echo $bench_dir_01 2>&1 |tee -a bench_dir_01
#echo $bench_dir_02 2>&1 |tee -a bench_dir_02
#echo $additions 2>&1 |tee -a additionsf

ans="global variable"				# global var 		
echo "				In script generator.sh"
echo
echo "This script prepares the benchmarking of FMM-YUK-A and FMM-YUK-U"
echo
echo -n "               Do you wish to proceed (Y/any key for N)?"

read ans
if test "$ans" != "Y" -a "$ans" != "y";
then exit 0;
fi


# step two
							#  global var particle count etc
choice="global variable"
particles="global variable"
echo "Choose between a particle generator, uniform cube,uniform sphere or plummer model"
echo "Type either \"cube\"  \"sphere\" or \"plummer\" "
read choice 

if test "$choice" != "cube" -a "$choice" != "sphere" -a "$choice" != "plummer"
then exit 0
fi

echo "Enter the desired number of particles"
read particles
echo
if test "$choice" == "cube";
then echo "Generating $choice of side 1 and $particles uniform particles";echo; cd $additions ; ./cube.o $particles > /dev/null ;
fi
if test "$choice" == "sphere"
then echo "Generating $choice of radius 1 and $particles uniform particles";echo; cd  $additions ; ./sphere.o $particles > /dev/null ;
fi
if test "$choice" == "plummer"
then echo "Generating $choice cluster of total radius 1 and $particles uniform particles";echo; cd $additions; ./plummer.o $particles > /dev/null ;
fi
echo "	Press any key to continue"
read -n 1 -s

echo
echo
echo "Completed"

# step three
echo "Copying binary data dump to respective folders"
cp binary_x $bench_dir_01/source/binary_x ; cp binary_y $bench_dir_01/source/binary_y ; cp binary_z $bench_dir_01/source/binary_z
cp binary_charge $bench_dir_01/source/binary_charge

cp binary_x $bench_dir_02/source/binary_x ; cp binary_y $bench_dir_02/source/binary_y ; cp binary_z $bench_dir_02/source/binary_z
cp binary_charge $bench_dir_02/source/binary_charge

#step four

echo
echo "		Problem size was $particles"
echo "		Descend into FMM-YUK-U and compile?"
echo "		Press any key to continue"
read -n 1 -s


cd $bench_dir_01/source/					
cp $additions/result_analysis.o ./result_analysis.o		# result analyzer copied to folder

rm uniyukdriver.f 
rm fmmuniyuk.f 
rm yukoperators.f

sed -e 's/100000/'$particles'/g' < initial_uniyukdriver.f > uniyukdriver.f # problem size is changed in U uniyukdriver.f
sed -e 's/100000/'$particles'/g' < initial_fmmuniyuk.f > fmmuniyuk.f	   # problem size is changed in U fmmuniyuk.f
sed  's/100000/'$particles'/g' < initial_yukoperators.f > yukoperators.f   # problem size is changed in U yukoperators.f
make

# step five

echo
echo "		Descend into FMM-YUK-A and compile?"
echo "		Press any key to continue"
read -n 1 -s


cd $bench_dir_02/source/
cp $additions/result_analysis.o ./result_analysis.o		# result analyzer copied to folder

rm adapyukdriver.f
rm fmmadapyuk.f
rm yukoperators.f

sed -e 's/100000/'$particles'/g' < initial_adapyukdriver.f > adapyukdriver.f # problem size is changed in A adapyukdriver.f 
sed -e 's/100000/'$particles'/g' < initial_fmmadapyuk.f > fmmadapyuk.f	     # problem size is changed in A fmmadapyuk.f
sed -e 's/100000/'$particles'/g' < initial_yukoperators.f > yukoperators.f   # #problem size is changed in A yukoperators.f
make 

echo
echo
echo "This concludes generate script and benchmark preparation"
echo "Would you like to run the benchmark?"
read ans
if test "$ans" != "Y" -a "$ans" != "y";
then exit 0;
fi

cd $bench_dir ; chmod u+x run.sh ; ./run.sh		# over to generate.sh script



