#!/bin/bash
# Run this script for benchmark preparation

# step one 
# compile particle generators and enter size of problem
#Define bash global variable
answer="global variable"
clear
echo 
echo "This script prepares the benchmarking of FMM-YUK-A and FMM-YUK-U"
echo
echo -n "               Do you wish to proceed (Y/any key for N)?"

read ans
if test "$ans" != "Y" -a "$ans" != "y";
then exit 0;
fi

make clean ; make ;

# step two
#Define bash global variable
choice="global variable"
particles="global variable"
#clear
echo "Choose between a particle generator, uniform cube,uniform sphere or plummer model"
echo "Type either \"cube\"  \"sphere\" or \"plummer\" "
read choice 

if test "$choice" != "cube" -a "$choice" != "sphere" -a "$choice" != "plummer"
then exit 0
fi

echo "Enter the desired number of particles"
read particles
echo
if test "$choice" == "cube";
then echo "Generating $choice of side 1 and $particles uniform particles";echo; ./cube.o $particles > /dev/null ;
fi
if test "$choice" == "sphere"
then echo "Generating $choice of radius 1 and $particles uniform particles";echo; ./sphere.o $particles > /dev/null ;
fi
if test "$choice" == "plummer"
then echo "Generating $choice sphere of total radius 1 and $particles uniform particles";echo; ./plummer.o $particles > /dev/null ;
fi
echo "	Press any key to continue"
read -n 1 -s

#if test "$choice"=="sphere";
#then echo "Generating $choice of radius 1 and $particles uniform particles";echo; ./sphere.o $particles;
#fi
#ls -lsa

echo
#echo "At this point the data dump has been created"
#echo "dump--> plain text float separated by commas"
#echo "fortran.dump --> fortran float "
#echo "binary_dump --> for programm input  purposes"
#echo "	Press any key to continue"
#read -n 1 -s

echo
echo "Dump verification by dump_validator"
echo "dump_validator gets binary size and loads datadump comparing it to plain text"
echo;./dump_validator_x.o; echo "Running sdiff -sb for x coordinates";sdiff -sb dump_x test_dump_x;
echo
echo "		Press any key to continue"
read -n 1 -s
echo;./dump_validator_y.o; echo "Running sdiff -sb for y coordinates";sdiff -sb dump_y test_dump_y;
echo
echo "		Press any key to continue"
read -n 1 -s
echo;./dump_validator_z.o; echo "Running sdiff -sb for z coordinates";sdiff -sb dump_z test_dump_z;
echo
echo "		Press any key to continue"
read -n 1 -s
echo;./dump_validator_charge.o; echo "Running sdiff -sb for charge";sdiff -sb dump_charge test_dump_charge;
echo
echo "		Press any key to continue"
read -n 1 -s

echo
echo "Complete and Success"
echo "Copying binary data dump to respective folders"

cp binary_x 01.FMM-YUK-U/source/binary_x
cp binary_y 01.FMM-YUK-U/source/binary_y
cp binary_z 01.FMM-YUK-U/source/binary_z
cp binary_charge 01.FMM-YUK-U/source/binary_charge
cp binary_x 02.FMM-YUK-A/source/binary_x
cp binary_y 02.FMM-YUK-A/source/binary_y
cp binary_z 02.FMM-YUK-A/source/binary_z
cp binary_charge 02.FMM-YUK-A/source/binary_charge

#cp fortran.dump 01.FMM-YUK-U/source/fortran.dump
#cp fortran.dump 02.FMM-YUK-A/source/fortran.dump
#clear
echo "		Problem size was $particles"
echo "		Descend into FMM-YUK-U and compile?"
echo "		Press any key to continue"
read -n 1 -s

#problem size is changed in U uniyukdriver.f
cd 01.FMM-YUK-U/source/
make clean
cp ../../result_analysis.o result_analysis.o
rm uniyukdriver.f 
sed -e 's/100000/'$particles'/g' < initial_uniyukdriver.f > uniyukdriver.f
#make #> /dev/null

#problem size is changed in U fmmuniyuk.f
rm fmmuniyuk.f 
sed -e 's/100000/'$particles'/g' < initial_fmmuniyuk.f > fmmuniyuk.f
#problem size is changed in U yukoperators.f
rm yukoperators.f
sed  's/100000/'$particles'/g' < initial_yukoperators.f > yukoperators.f
make

#clear
echo "		Descend into FMM-YUK-A and compile?"
echo "		Press any key to continue"
read -n 1 -s

#problem size is changed in A adapyukdriver.f 
cd ../../02.FMM-YUK-A/source/;
rm adaplapdriver.f
make clean
cp ../../result_analysis.o result_analysis.o
sed -e 's/100000/'$particles'/g' < initial_adapyukdriver.f > adapyukdriver.f
sed -e 's/100000/'$particles'/g' < initial_fmmadapyuk.f > fmmadapyuk.f
sed -e 's/100000/'$particles'/g' < initial_yukoperators.f > yukoperators.f
make #>/dev/null
clear
echo "		RUN BENCHMARK?"
echo "		Press any key to continue"
read -n 1 -s

cd ../../01.FMM-YUK-U/source/ ; 
clear
echo 
echo "		RUNNING Yukawa Potential Uniform Solver for $particles particles"
echo
./fmm
cd ../../02.FMM-YUK-A/source/;
clear
echo
echo "		RUNNING Yukawa Potential Adaptive Solver for $particles particles"
./fmm

